% Function to copy the cavities at the other unit cells
function [inp, count, model] = draw_cavity_array(x, y, tag, inp, count, geom, model, workplane)

tri_side = geom.mech.amech - geom.mech.w*sqrt(3);
tri_a1_x = geom.mech.amech/2 + [geom.mech.w*sqrt(3)/2 geom.mech.w*sqrt(3)/2+tri_side/4 geom.mech.amech/2 geom.mech.amech/2];
tri_a1_y = [geom.mech.w/2 geom.mech.w/2+tri_side*sqrt(3)/4 geom.mech.amech/(2*sqrt(3)) geom.mech.w/2];

[tri_a2_x, tri_a2_y] = rotate(tri_a1_x, tri_a1_y, geom.mech.amech/2, 0, -120);
[tri_a3_x, tri_a3_y] = rotate(tri_a1_x, tri_a1_y, geom.mech.amech/2, 0, -240);

tri_b1_x = tri_a1_x;
tri_b1_y = -tri_a1_y;

[tri_b2_x, tri_b2_y] = rotate(tri_b1_x, tri_b1_y, geom.mech.amech/2, 0, -120);
[tri_b3_x, tri_b3_y] = rotate(tri_b1_x, tri_b1_y, geom.mech.amech/2, 0, -240);

l1_x = geom.mech.amech/2 + [geom.mech.r geom.mech.amech/2 geom.mech.amech/2 geom.mech.r];
l1_y = [geom.mech.w/2 geom.mech.w/2 -geom.mech.w/2 -geom.mech.w/2];

[l2_x, l2_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -60);
[l3_x, l3_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -120);
[l4_x, l4_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -180);
[l5_x, l5_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -240);
[l6_x, l6_y] = rotate(l1_x, l1_y, geom.mech.amech/2, 0, -300);

% plot(tri_a1_x, tri_a1_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_a2_x, tri_a2_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_a3_x, tri_a3_y, 'color', colour, 'LineWidth', 0.5);
% plot(tri_b1_x, tri_b1_y, 'color', colour, 'LineWidth', 0.5);

ina1 = inpolygon(x(1:end-1), y(1:end-1), tri_a1_x, tri_a1_y);
ina2 = inpolygon(x(1:end-1), y(1:end-1), tri_a2_x, tri_a2_y);
ina3 = inpolygon(x(1:end-1), y(1:end-1), tri_a3_x, tri_a3_y);
inb1 = inpolygon(x(1:end-1), y(1:end-1), tri_b1_x, tri_b1_y);
inb2 = inpolygon(x(1:end-1), y(1:end-1), tri_b2_x, tri_b2_y);
inb3 = inpolygon(x(1:end-1), y(1:end-1), tri_b3_x, tri_b3_y);
inl1 = inpolygon(x(1:end-1), y(1:end-1), l1_x, l1_y);
inl2 = inpolygon(x(1:end-1), y(1:end-1), l2_x, l2_y);
inl3 = inpolygon(x(1:end-1), y(1:end-1), l3_x, l3_y);
inl4 = inpolygon(x(1:end-1), y(1:end-1), l4_x, l4_y);
inl5 = inpolygon(x(1:end-1), y(1:end-1), l5_x, l5_y);
inl6 = inpolygon(x(1:end-1), y(1:end-1), l6_x, l6_y);

if sum(inl1)>0
    region = 'l1';
elseif sum(inl2)>0
    region = 'l2';
elseif sum(inl3)>0
    region = 'l3';
elseif sum(inl4)>0
    region = 'l4';
elseif sum(inl5)>0
    region = 'l5';
elseif sum(inl6)>0
    region = 'l6';
elseif sum(ina1)>0
    region = 'a1';
elseif sum(ina2)>0
    region = 'a2';
elseif sum(ina3)>0
    region = 'a3';
elseif sum(inb1)>0
    region = 'b1';
elseif sum(inb2)>0
    region = 'b2';
elseif sum(inb3)>0
    region = 'b3';
end

% x_cen = mean(x(1:end-1));
% y_cen = mean(y(1:end-1));

pol = workplane.geom.create(tag, 'Polygon');
pol.set('source', 'table');
l = 1;
for k=1:2:length(x)
    pol.setIndex('table', num2str(x(k),'%10.9e'), l-1, 0);
    pol.setIndex('table', num2str(y(k),'%10.9e'), l-1, 1);
    l = l+1;
end
                    
if strcmp(region, 'a1')
    if count.a1==1
        inp = rmfield(inp,'a1');
    end
    
    inp.a1(count.a1) = {tag};
    count.a1 = count.a1 + 1;
    
elseif strcmp(region, 'a2')
    if count.a2==1
        inp = rmfield(inp,'a2');
    end
    
    inp.a2(count.a2) = {tag};
    count.a2 = count.a2 + 1;
    
elseif strcmp(region, 'a3')
    if count.a3==1
        inp = rmfield(inp,'a3');
    end
    
    inp.a3(count.a3) = {tag};
    count.a3 = count.a3 + 1;
    
elseif strcmp(region, 'b1')
    if count.b1==1
        inp = rmfield(inp,'b1');
    end
    
    inp.b1(count.b1) = {tag};
    count.b1 = count.b1 + 1;
    
elseif strcmp(region, 'b2')
    if count.b2==1
        inp = rmfield(inp,'b2');
    end
    
    inp.b2(count.b2) = {tag};
    count.b2 = count.b2 + 1;
    
elseif strcmp(region, 'b3')
    if count.b3==1
        inp = rmfield(inp,'b3');
    end
    
    inp.b3(count.b3) = {tag};
    count.b3 = count.b3 + 1;
    
elseif strcmp(region, 'l1')
    if count.l1==1
        inp = rmfield(inp,'l1');
    end
    
    inp.l1(count.l1) = {tag};
    count.l1 = count.l1 + 1;
    
elseif strcmp(region, 'l2')
    if count.l2==1
        inp = rmfield(inp,'l2');
    end
    
    inp.l2(count.l2) = {tag};
    count.l2 = count.l2 + 1;
    
elseif strcmp(region, 'l3')
    if count.l3==1
        inp = rmfield(inp,'l3');
    end
    
    inp.l3(count.l3) = {tag};
    count.l3 = count.l3 + 1;
    
elseif strcmp(region, 'l4')
    if count.l4==1
        inp = rmfield(inp,'l4');
    end
    
    inp.l4(count.l4) = {tag};
    count.l4 = count.l4 + 1;
    
elseif strcmp(region, 'l5')
    if count.l5==1
        inp = rmfield(inp,'l5');
    end
    
    inp.l5(count.l5) = {tag};
    count.l5 = count.l5 + 1;
    
elseif strcmp(region, 'l6')
    if count.l6==1
        inp = rmfield(inp,'l6');
    end
    
    inp.l6(count.l6) = {tag};
    count.l6 = count.l6 + 1;
end

end
